from app.db import database

COLLECTION_NAME = "availability_settings"

def get_availability_settings(db: database.MongoDB) -> dict:
    return db[COLLECTION_NAME].find_one({}) or {}

def update_availability_settings(account_id: str, data: dict, db: database.MongoDB) -> dict:
    if "track_by" not in data:
        data["track_by"] = "km"  # Default value if not set
    db[COLLECTION_NAME].update_one({"account_id": account_id}, {"$set": data}, upsert=True)
    return db[COLLECTION_NAME].find_one({"account_id": account_id})
